/* SigmaStar trade secret */
/* Copyright (c) [2019~2020] SigmaStar Technology.
All rights reserved.

Unless otherwise stipulated in writing, any and all information contained
herein regardless in any format shall remain the sole proprietary of
SigmaStar and be kept in strict confidence
(SigmaStar Confidential Information) by the recipient.
Any unauthorized act including without limitation unauthorized disclosure,
copying, use, reproduction, sale, distribution, modification, disassembling,
reverse engineering and compiling of the contents of SigmaStar Confidential
Information is unlawful and strictly prohibited. SigmaStar hereby reserves the
rights to any and all damages, losses, costs and expenses resulting therefrom.
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "drv_uart_api.h"
#include "cam_os_wrapper.h"
#include "cam_proc_common.h"
#include "cam_proc_cli.h"

///|| (x) == '\\' || (x) == '\/'
#define _CAMPROC_IS_WHITE(x)                ((x) == ' ' || (x) == '\t' || (x) == '\\' || (x) == '/')
#define _CAMPROC_IS_SPACE(x)                _CAMPROC_IS_WHITE(x)
#define _CAMPROC_EAT_WHITE(x)               while( _CAMPROC_IS_WHITE(*(x))) x++;
#define _CAMPROC_EAT_NON_WHITE(x)           while( *(x)&&!_CAMPROC_IS_WHITE(*(x))) x++;

static void _CamProcListNodesPerEntryEx(struct CamOsListHead_t * pSrcList, char * pPathBuf, int nPathBufLen)
{
    struct CamOsListHead_t *l;
    CamProcEntry_t * pTmpListEntry;

    CAM_OS_LIST_FOR_EACH( l, pSrcList ) {
        pTmpListEntry = CAM_OS_LIST_ENTRY( l, CamProcEntry_t, link );
        if(pTmpListEntry->pfCatCB) {
            //it's a node
            CamOsPrintf("%s%s\n", pPathBuf, pTmpListEntry->aEntryName);
        }
    }

    CAM_OS_LIST_FOR_EACH( l, pSrcList ) {
        pTmpListEntry = CAM_OS_LIST_ENTRY( l, CamProcEntry_t, link );
        if(pTmpListEntry->pfCatCB == NULL) {
            char * pTemp;

            if(strlen(pPathBuf) + strlen(pTmpListEntry->aEntryName) >= nPathBufLen) {
                CamOsPrintf("%s : Path buffer is not enough!\n", __FUNCTION__);
                return;
            }

            pTemp = pPathBuf + strlen(pPathBuf);
            sprintf(pTemp,"%s/", pTmpListEntry->aEntryName);
            CamOsPrintf("%s\n", pPathBuf);

            //it's a directory entry, recursively search
            _CamProcListNodesPerEntryEx(&pTmpListEntry->sSubNodeList,pPathBuf,nPathBufLen);

            *pTemp = 0;
        }
    }
}

static CamProcEntry_t * _CamProcFindEntryByName(struct CamOsListHead_t * pSrcList , const char *name)
{
    struct CamOsListHead_t *l;
    CamProcEntry_t *pTmpListEntry;

    CAM_OS_LIST_FOR_EACH( l, pSrcList ) {
        pTmpListEntry = CAM_OS_LIST_ENTRY( l, CamProcEntry_t, link );
        if(strcmp(pTmpListEntry->aEntryName,name) == 0) {
            return pTmpListEntry;
        }
    }
    return NULL;
}

static char * _CamProcParsingToken(char * pSourceStr, char * pOutBuf , int nBufLen)
{
    int i = 0;
    char *pTmpChar = pSourceStr;
    u32 nSourceRemainLen;

    _CAMPROC_EAT_WHITE(pTmpChar)
    nSourceRemainLen = strlen(pTmpChar);

    while(i < nBufLen && nSourceRemainLen)
    {
        if(_CAMPROC_IS_SPACE(*pTmpChar)) {
            break;
        }

        *(pOutBuf + i) = *pTmpChar;
        pTmpChar++;
        i++;
        nSourceRemainLen--;
    }

    *(pOutBuf + i) = 0;
    return pTmpChar;
}

int CamProcCat(CLI_t * pCli, char * p)
{
    CamProcEntry_t *pTargetEntry;
    struct CamOsListHead_t *pSourceList;
    char aTargetName[32];
    char *pTmpChar;

    pTargetEntry = NULL;
    pSourceList = &_proc_root_list;
    aTargetName[0] = 0;
    pTmpChar = p;

    while(1) {
        pTmpChar = _CamProcParsingToken(pTmpChar, aTargetName, sizeof(aTargetName));
        if(aTargetName[0] == 0)
            break;
        pTargetEntry = _CamProcFindEntryByName(pSourceList,aTargetName);

        if(pTargetEntry)
            pSourceList = &pTargetEntry->sSubNodeList;
        else
            break;
    }

    if(pTargetEntry && pTargetEntry->pfCatCB)
        pTargetEntry->pfCatCB(NULL, 0);
    else
        return eCLI_PARSE_ERROR;

    return eCLI_PARSE_OK;
}

int CamProcEcho(CLI_t * pCli, char * p)
{
    CamProcEntry_t *pTargetEntry;
    struct CamOsListHead_t *pSourceList;
    char aTargetName[32];
    //u32 nStrLen;
    char *pTmpChar;
    char *pOutChar;

    //UartSendTrace("p=%s\n",p);

    pOutChar = strstr(p, ">");

    if(!pOutChar)
        return eCLI_PARSE_ERROR;

    pTargetEntry = NULL;
    pSourceList = &_proc_root_list;
    aTargetName[0] = 0;
    pTmpChar = pOutChar + 1;//skip ">"
    pTmpChar = strstr(pTmpChar, "/proc");

    if(!pTmpChar)
        return eCLI_PARSE_ERROR;

    pTmpChar += strlen("/proc");

    while(1) {
        pTmpChar = _CamProcParsingToken(pTmpChar, aTargetName, sizeof(aTargetName));
        if(aTargetName[0] == 0)
            break;
        pTargetEntry = _CamProcFindEntryByName(pSourceList,aTargetName);

        if(pTargetEntry)
            pSourceList = &pTargetEntry->sSubNodeList;
        else
            break;
    }

    if(pTargetEntry && pTargetEntry->pfEchoCB) {
        *(p + (pOutChar - p - 1)) = 0;
        //CamOsPrintf("CamProcEcho[%d:%d] : %s\n",pOutChar - p - 1, strlen(p) ,p);
        pTargetEntry->pfEchoCB(p, strlen(p));
    }
    else {
        return eCLI_PARSE_ERROR;
    }

    return eCLI_PARSE_OK;
}

int CamProcLs(CLI_t * pCli, char * p)
{
    CamProcEntry_t *pTargetEntry;
    struct CamOsListHead_t *pSourceList;
    char aTargetName[128];//including path buffer
    char *pTmpChar;

    pTargetEntry = NULL;
    pSourceList = &_proc_root_list;
    aTargetName[0] = 0;
    pTmpChar = p;

    //find the root directory entry in path which is stored in pTmpChar
    while(1) {
        pTmpChar = _CamProcParsingToken(pTmpChar, aTargetName, sizeof(aTargetName));
        if(aTargetName[0] == 0)
            break;
        pTargetEntry = _CamProcFindEntryByName(pSourceList,aTargetName);

        if(pTargetEntry)
            pSourceList = &pTargetEntry->sSubNodeList;
        else
            break;
    }

    if(pSourceList != &_proc_root_list) {
        CamOsPrintf("/%s",pTargetEntry->aEntryName);
        sprintf(aTargetName,"%s/", pTargetEntry->aEntryName);
    }
    else {
        aTargetName[0] = '/';
        aTargetName[1] = 0;
    }

    _CamProcListNodesPerEntryEx(pSourceList, aTargetName, sizeof(aTargetName));

    return eCLI_PARSE_OK;
}

static int _Cat(CLI_t * pCli, char * p)
{
    char *pTmpChar = NULL;
    bool bOrgBufferModeEnable;
    int Ret;

    if (CliTokenCount(pCli) != 1)
    {
        return eCLI_PARSE_INVALID_PARAMETER;
    }

    pTmpChar = CliTokenPop(pCli);
    pTmpChar = strstr(pTmpChar,"/proc");

    if (!pTmpChar)
    {
        CamOsPrintf("Not support real file or path error\n");
        return eCLI_PARSE_ERROR;
    }

    bOrgBufferModeEnable = get_msg_buffer_mode();
    if (bOrgBufferModeEnable)
    {
        send_msg_buffer_mode_en_no_print(FALSE);
        send_msg_buffer_mode_flush();
    }

    Ret = CamProcCat(pCli, pTmpChar + strlen("/proc"));

    if (bOrgBufferModeEnable) {
        send_msg_buffer_mode_en_no_print(TRUE);
    }
    return Ret;
}
SS_RTOS_CLI_CMD(cat,
        "show context of a proc node",
        "Usage: cat /proc/cmdq/fps",
        _Cat);

static int _Echo(CLI_t * pCli, char * p)
{
    char *pTmpChar = NULL;
    int Ret;
    char aStrBuf[512];

    CliReassembleToken(pCli, aStrBuf, sizeof(aStrBuf));
    pTmpChar = strstr(aStrBuf,"/proc");

    if (!pTmpChar)
    {
        CamOsPrintf("Not support real file or path error\n");
        return eCLI_PARSE_ERROR;
    }

    Ret = CamProcEcho(pCli, aStrBuf);

    return Ret;
}
SS_RTOS_CLI_CMD(echo,
        "write string into a proc node",
        "Usage: echo 30 > /proc/cmdq/fps",
        _Echo);

static int _Procls(CLI_t * pCli, char * p)
{
    char *pTmpChar = NULL;
    int Ret;
    char aStrBuf[128];

    CliReassembleToken(pCli, aStrBuf, sizeof(aStrBuf));
    pTmpChar = strstr(aStrBuf,"/proc");

    if(!pTmpChar) {
        aStrBuf[0] = '/';
        aStrBuf[1] = 0;
        Ret = CamProcLs(pCli, aStrBuf);
    }
    else {
        Ret = CamProcLs(pCli, pTmpChar + strlen("/proc"));
    }

    return Ret;
}
SS_RTOS_CLI_CMD(procls,
        "show directory entries and nodes of proc",
        "Usage: procls /proc",
        _Procls);

